<?php
require_once __DIR__ . '/core.php';

$update = json_decode(file_get_contents('php://input'), true);
if (!$update) {
    exit;
}

$message  = $update['message']        ?? null;
$callback = $update['callback_query'] ?? null;

$fromId = $message['from']['id']            ?? ($callback['from']['id']            ?? null);
$chatId = $message['chat']['id']            ?? ($callback['message']['chat']['id'] ?? null);
$text   = $message['text']                  ?? null;
$data   = $callback['data']                 ?? null;

if (!$fromId) {
    exit;
}

global $db, $steps, $settings, $products, $panels;

ensureUser($fromId);

// Deep Link (inviter)
if ($text && strpos($text, '/start ') === 0) {
    $inviterId = str_replace('/start ', '', $text);
    if (
        $inviterId != $fromId &&
        !isset($db['users'][$fromId]['inviter']) &&
        isset($db['users'][$inviterId])
    ) {
        $db['users'][$fromId]['inviter'] = $inviterId;
        $db['users'][$inviterId]['sub_count'] += 1;
        saveDB();
        bot('sendMessage', [
            'chat_id' => $inviterId,
            'text'    => "🎉 یک کاربر جدید با لینک شما وارد ربات شد!"
        ]);
    }
    $text = '/start';
}

// Start / Back
if ($text == '/start' || $text == "🔙 بازگشت به منو") {
    $steps[$fromId] = 'none';
    saveSteps($steps);

    bot('sendMessage', [
        'chat_id'      => $chatId,
        'text'         => "💎 به ربات فروش خوش آمدید. گزینه مورد نظر را انتخاب کنید:",
        'reply_markup' => getMainMenu($fromId)
    ]);
    exit;
}

// Route
require_once __DIR__ . '/admin.php';
require_once __DIR__ . '/store.php';
require_once __DIR__ . '/services.php';