<?php
// admin.php

if (!isset($fromId)) return;

global $db, $settings, $steps, $products, $panels;

$adminMainBtns = [
    "➕ اضافه کردن پنل",
    "🖥 مدیریت پنل‌ها",
    "➕ افزودن محصول",
    "❌ حذف محصول",
    "📊 آمار فروش",
    "📢 پیام همگانی",
    "💳 تنظیم کارت",
    "📚 تنظیم آموزش",
    "🎁 مدیریت تست",
    "⚙️ پنل مدیریت"
];

// --- ADMIN MAIN BUTTONS ---
if ($fromId == ADMIN_ID) {

    if ($text && in_array($text, $adminMainBtns)) {
        $steps[$fromId] = 'none';
        saveSteps($steps);
    }

    switch ($text) {
        case "⚙️ پنل مدیریت":
            bot('sendMessage', [
                'chat_id'      => $chatId,
                'text'         => "🛠 مدیریت کل سیستم:",
                'reply_markup' => getAdminMenu()
            ]);
            break;

        case "➕ اضافه کردن پنل":
            $steps[$fromId] = 'add_panel_name';
            saveSteps($steps);
            bot('sendMessage', [
                'chat_id'      => $chatId,
                'text'         => "📛 یک نام برای این پنل وارد کنید (مثلاً: سرور فنلاند):",
                'reply_markup' => json_encode(['remove_keyboard' => true])
            ]);
            break;

        case "🖥 مدیریت پنل‌ها":
            if (empty($panels)) {
                bot('sendMessage', [
                    'chat_id' => $chatId,
                    'text'    => "⚠️ هیچ پنلی ثبت نشده است."
                ]);
            } else {
                $btns = [];
                foreach ($panels as $id => $p) {
                    $prefix = ($settings['active_panel_idx'] == $id && $settings['active_panel_idx'] !== null)
                        ? "✅ "
                        : "⚪️ ";
                    $btns[] = [[
                        'text'          => $prefix . $p['name'],
                        'callback_data' => "manage_p_$id"
                    ]];
                }
                bot('sendMessage', [
                    'chat_id'      => $chatId,
                    'text'         => "لیست پنل‌ها:",
                    'reply_markup' => json_encode(['inline_keyboard' => $btns])
                ]);
            }
            break;

        case "➕ افزودن محصول":
            $steps[$fromId] = 'p_name';
            saveSteps($steps);
            bot('sendMessage', [
                'chat_id'      => $chatId,
                'text'         => "🏷 نام پلن را وارد کنید:",
                'reply_markup' => json_encode(['remove_keyboard' => true])
            ]);
            break;

        case "❌ حذف محصول":
            if (empty($products)) {
                bot('sendMessage', [
                    'chat_id' => $chatId,
                    'text'    => "محصولی وجود ندارد."
                ]);
            } else {
                $btns = [];
                foreach ($products as $id => $p) {
                    $btns[] = [[
                        'text'          => "🗑 " . $p['name'],
                        'callback_data' => "del_prod_$id"
                    ]];
                }
                bot('sendMessage', [
                    'chat_id'      => $chatId,
                    'text'         => "حذف محصول:",
                    'reply_markup' => json_encode(['inline_keyboard' => $btns])
                ]);
            }
            break;

        case "📊 آمار فروش":
            $u = count($db['users']);
            $s = number_format($db['stats']['total_sales'] ?? 0);
            bot('sendMessage', [
                'chat_id' => $chatId,
                'text'    => "📊 آمار:\n👥 کل کاربران: $u\n💰 فروش: $s تومان"
            ]);
            break;

        case "💳 تنظیم کارت":
            $steps[$fromId] = 'set_card';
            saveSteps($steps);
            bot('sendMessage', [
                'chat_id'      => $chatId,
                'text'         => "💳 شماره کارت را وارد کنید:",
                'reply_markup' => json_encode(['remove_keyboard' => true])
            ]);
            break;

        case "📚 تنظیم آموزش":
            $steps[$fromId] = 'set_tut';
            saveSteps($steps);
            bot('sendMessage', [
                'chat_id'      => $chatId,
                'text'         => "📚 متن آموزش را بفرستید:",
                'reply_markup' => json_encode(['remove_keyboard' => true])
            ]);
            break;

        case "📢 پیام همگانی":
            $steps[$fromId] = 'step_broad';
            saveSteps($steps);
            bot('sendMessage', [
                'chat_id'      => $chatId,
                'text'         => "پیام خود را جهت ارسال به همه کاربران بفرستید:",
                'reply_markup' => json_encode(['remove_keyboard' => true])
            ]);
            break;

        case "🎁 مدیریت تست":
            $mb = $settings['trial_mb'];
            $hr = $settings['trial_hours'];
            bot('sendMessage', [
                'chat_id'      => $chatId,
                'text'         => "🎁 تنظیمات تست فعلی:\nحجم: $mb MB\nزمان: $hr ساعت",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [[
                        ['text' => "تغییر حجم", 'callback_data' => "edit_trial_mb"],
                        ['text' => "تغییر زمان", 'callback_data' => "edit_trial_hr"]
                    ]]
                ])
            ]);
            break;
    }
}

// --- CALLBACKS (ADMIN) ---
if ($data) {
    if (strpos($data, 'manage_p_') === 0) {
        $id = str_replace('manage_p_', '', $data);
        if (!isset($panels[$id])) return;

        $p          = $panels[$id];
        $activeText = ($settings['active_panel_idx'] == $id && $settings['active_panel_idx'] !== null)
            ? "🌟 این پنل فعلاً برای فروش فعال است."
            : "⚠️ این پنل غیرفعال است.";

        bot('editMessageText', [
            'chat_id'    => $chatId,
            'message_id' => $callback['message']['message_id'],
            'text'       => "🖥 مدیریت پنل: *{$p['name']}*\n\n🔗 آدرس: `{$p['url']}`\n👤 یوزر الگو: `{$p['template']}`\n\n$activeText",
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "✅ فعال‌سازی برای فروش", 'callback_data' => "active_p_$id"]],
                    [['text' => "⚙️ تنظیم یوزر الگو (اینباند)", 'callback_data' => "set_temp_$id"]],
                    [['text' => "🗑 حذف این پنل", 'callback_data' => "rem_p_$id"]]
                ]
            ])
        ]);
    }

    if (strpos($data, 'active_p_') === 0) {
        $id = str_replace('active_p_', '', $data);
        if (!isset($panels[$id])) return;

        $settings['active_panel_idx'] = (int)$id;
        saveSettings();

        bot('answerCallbackQuery', [
            'callback_query_id' => $callback['id'],
            'text'              => "پنل {$panels[$id]['name']} فعال شد.",
            'show_alert'        => true
        ]);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "🛠 عملیات با موفقیت انجام شد.",
            'reply_markup' => getAdminMenu()
        ]);
    }

    if (strpos($data, 'set_temp_') === 0) {
        $id = str_replace('set_temp_', '', $data);
        $steps[$fromId] = "wait_template|$id";
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "لطفاً در پنل مرزبان خود یک یوزر جدید بسازید و نام دقیق آن را اینجا بفرستید تا ربات از تنظیمات آن کپی برداری کند:"
        ]);
    }

    if (strpos($data, 'rem_p_') === 0) {
        $id = str_replace('rem_p_', '', $data);
        unset($panels[$id]);
        $panels = array_values($panels);

        if ($settings['active_panel_idx'] == $id) {
            $settings['active_panel_idx'] = null;
        }
        savePanels();
        saveSettings();

        bot('answerCallbackQuery', [
            'callback_query_id' => $callback['id'],
            'text'              => "پنل حذف شد."
        ]);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "🗑 پنل با موفقیت حذف شد.",
            'reply_markup' => getAdminMenu()
        ]);
    }

    if ($data == 'edit_trial_mb') {
        $steps[$fromId] = 'wait_t_mb';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "حجم تست را به مگابایت وارد کنید (مثلا 100):"
        ]);
    }

    if ($data == 'edit_trial_hr') {
        $steps[$fromId] = 'wait_t_hr';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "زمان تست را به ساعت وارد کنید (مثلا 2):"
        ]);
    }

    if (strpos($data, 'del_prod_') === 0) {
        $id = str_replace('del_prod_', '', $data);
        unset($products[$id]);
        $products = array_values($products);
        saveProducts();

        bot('editMessageText', [
            'chat_id'    => $chatId,
            'message_id' => $callback['message']['message_id'],
            'text'       => "✅ محصول حذف شد."
        ]);
    }
}